/******************************************************************************
 * @file        ADC12B.h
 * @version     V1.00.01
 * $Revision:   0 $
 * $Date:       2017-01-10 $
 * @brief       12Bits SAR ADC Driver Header File
 *
 * @note
 *
 * Copyright (C) 2016 AMICCOM Electronics Corp. All rights reserved.
 ******************************************************************************/
 
#ifndef __ADC12B_H__
#define __ADC12B_H__

#include "A9139M0.h"

/** @addtogroup Std_Driver Standard Driver
    @{
*/
/** @addtogroup ADC12B_Driver UART Driver
    @{
*/

/**
 *
 * @brief   Set ADC Channel for ADC12B
 *
 * @param   *adc12b                 ADC12B Pointer
 * @param   ch                      Select ADC Channel. Value=0~7.
 * @return  none
 */
extern void ADC12B_SetCH(ADC12B_Type *adc12b, uint32_t ch);

/**
 *
 * @brief   Measure MVADC value with continue mode
 *
 * @param   *adc12b                 ADC12B Pointer
 * @return  MVADC
 */
extern uint32_t ADC12B_Measure(ADC12B_Type *adc12b, uint32_t ch);

/**
 *
 * @brief   Set IO and Initial 12Bits SAR ADC with continue mode
 *
 * @param   *adc12b                 ADC12B Pointer
 * @param   ch                      Select ADC Channel. Value=0~7.
 * @return  none
 */
extern void ADC12B_Initial(ADC12B_Type *adc12b, uint32_t ch);


/*@}*/ /* end of group ADC12B_Driver */
/*@}*/ /* end of group Std_Driver */

#endif
